<?php 
/*********************************************************************************
*
 + El contenido de este archivo están sujeto a la licencia de SAI OPEN 
 + Todos los derechos reservados.
 Empresa:		Grupo Sai S.A.S www.sai-open.com
 Autor: 		Helio Flavio Camelo G.
 Proposito:		Archivo de utilidaddes comunes en la sincronizacion del sistema crm con la base de datos FireBird de SaiOpen
 Mail: 			helioscamelo@gmail.com
*
 ********************************************************************************/ 
defined( 'UtilsWF' ) or die( 'Acceso Restringido. UtilidadesWF' );

require_once('include/utils/utils.php');
global $adb;

global $dbFirebird;  // se instancia den sincronAuto.php //$dbFirebird = new FireBird();

/////////////////////////////////////// SETEO DE VARIABLES PRINCIAPALES //////////////////////////////////////
///seteo de tabla principales:: me idica la tablas habilitadas para leer el campo de llave para el valor comun entre los dos sistemas.
global $tablasPrinCRM;
$tablasPrinCRM=array('vtiger_account','vtiger_contactdetails','vtiger_products');

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

function escribe(){
	return 'Utilidades WF';
	}
	
//Des. lee las tablas relacionadas  a una comun para el sistema crm:: ejemplo vtiger_account tiene como tablas relacionadas: vtiger_accountbillads, vtiger_accountscf
function getTablaCrmXml($table){/*
	//lectura de el xml de parametros
	 $rutaxml="data/tablasReltadSaiSincron_CRM.xml";
		$xml = new SimpleXMLElement($rutaxml, null, true); 
		
		$tags=array();
			
		foreach( $xml->children() as $child){
		$getname=$child->getname();
		if(array_search($getname,$tags)===false)
		array_push($tags,$getname);
		}
		
		for($i=0;$i<count($tags);$i++){
			$status=false;
				foreach($xml->$tags[$i]->attributes() as $atr) {
    				if($status)
					 return trim($atr);
					//echo $atr."<br/>";
					if(trim($table)==trim($atr))
						$status=true;
				}				
			}//for
			
	*/}//end getTablaCrmXml()
//////////////////////////////////////////////////////////

//Funcion que se encaraga de leer los paramtros de el archivo xml que indica que debo sincronizar. y de que forma.
//Retorna: $xmlArr
function getDirectrizXml(){
	
	 //lectura de el xml de parametros
	 $rutaxml="data/configSaiSincron.xml";
			$xml = new SimpleXMLElement($rutaxml, null, true); 
			
		$tags=array();
		$values=array();
		// quita los duplicados y deja un array con claves unicas
		foreach( $xml->children() as $child){
		$getname=$child->getname();
		if(array_search($getname,$tags)===false)
		array_push($tags,$getname);
		}
		
		
				for($i=0;$i<count($tags);$i++){
					$valuesTemp=array();
					foreach( $xml->$tags[$i] as $sincron ) {
			
							array_push($valuesTemp,$sincron['entidad']); 	 	// 0
							array_push($valuesTemp,$sincron['tipoEntidad']); 	// 1
							array_push($valuesTemp,$sincron->fieldType);  		// 2 
							array_push($valuesTemp,$sincron->tabSai);     		// 3 
							array_push($valuesTemp,$sincron->fieldSai);  		// 4
							array_push($valuesTemp,$sincron->tabCrm);     		// 5
							array_push($valuesTemp,$sincron->fieldCrm);   		// 6 
							array_push($valuesTemp,$sincron->coditions);  		// 7
							array_push($valuesTemp,$sincron->fieldCrmKey);		// 8
							array_push($valuesTemp,$sincron->tabCrmKey);  		// 9
							array_push($valuesTemp,$sincron->fullTable);  		// 10
								//echo 'entidad: '.$sincron['entidad'];
							}
							$values[$i]=$valuesTemp;
							unset($valuesTemp);
						}
		return $values;
	} //close leeParamtrosXml
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Descrip: Funcion que me permito sacar el digito de verificacion de un documento ejemplo Nit.
//val In: No. Documento.
//Val Out: Digito de verificacion
function convertirNIT($vr){
	
$D = explode("-",$vr);
$NUM = explode(",","3,7,13,17,19,23,29,37,41,43,47,53,59,67,71" );
$CAD = $D[0];
$LEN = strlen($CAD);
for($i=0;$i<(count($NUM)-$LEN);$i++){
$CAD = "0".$CAD;
}
$SUM = 0;
$j = 0;
for($i=count($NUM)-1;$i>=0;$i--){
$SUM = $SUM+(substr($CAD,$i,1)*$NUM[$j]);
$j = $j + 1;
}
$R = $SUM % 11;
if($R==0){
$DV = 0;
}else{
if($R==1){
$DV = 1;
}else{
$DV = 11 - $R;
}
}
return ($DV);
}


//////////////////////////////////////////////////////////    FUNCIONES CONTACTOS - Direcciones de Envio////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
//Descrip: Función que me permite cambiar formato de fecha de año mes dia  A  mes dia año.
//val In: Fecha Original.
//Val Out: Fecha Cambiada.
function cambiarFormatoFecha($fecha){
	
    list($anio,$mes,$dia)=explode("-",$fecha);
    return $mes."/".$dia."/".$anio;
	
}  
//////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////////
//Desc: retorna el nombre de la entidad segun su id  ::
function getEntidadSai($entidadid){
	global $dbFirebird;
	$sqlEntidad="SELECT FIRST 1 ENTIDAD FROM ENTIDADES WHERE ID='".trim($entidadid)."'";//echo "<br/>".$sqlEntidad."<br/>";
	  $resEnt= $dbFirebird->setQuery($sqlEntidad);	
		while ($Ent = ibase_fetch_object($resEnt)) {
			return trim($Ent->ENTIDAD);
		}
	
	}
//////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////////////
////funcion que codifica los caracteres HTML en  caracteres UTF8

function unhtmlentities($string)
{
    // replace numeric entities
    $string = preg_replace('~&#x([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $string);
    $string = preg_replace('~&#([0-9]+);~e', 'chr("\\1")', $string);
    // replace literal entities
    $trans_tbl = get_html_translation_table(HTML_ENTITIES);
    $trans_tbl = array_flip($trans_tbl);
    return strtr($string, $trans_tbl);
}
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
//Desc: CODIFICA el valor de un campo para poder ser grabado cuando se lee desde el CRM y se guarda en SAI ::
function codeCrmToSai($valor){
	 $valor= utf8_decode($valor);
	 $valor= utf8_encode($valor);
	 $valor= utf8_decode($valor);
	 return $valor;
	}
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
//Desc: almacena en un documento tipo texto llamado LogCRM lo que va pasando con los procesos de actualizacion  :: LOG DE ACTIVIDADES
function logCrm($text){
	
$fphelio = fopen('D:\LogCRM.txt', 'a');
	fwrite($fphelio, "\r\n"  );
	fwrite($fphelio, date(r).' :.: '.$text);
	fwrite($fphelio, "\r\n" );
	fclose($fphelio);
	
	}
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////     NO UTILIZADA
//Desc: retorna la tabla de donde esta leyendose el crmkey 
function getTablaEspejo($crmKey,$tabDestino){  //NO UTILIZADA   //tabla donde se encuentra  el identificador comun,  entre sai y crm
	/*//Verifica si el campo proviene de una tabla dinamica	
	if(stristr($crmKey,'cf')!='false'){
		switch(trim($tabDestino)){
			case 'vtiger_account':
				$tablaespejo="vtiger_accountscf";
			break;
			
			case 'vtiger_products':
				$tablaespejo="vtiger_productcf";
			break;
			
			default:
				$tablaespejo=$tabDestino."cf";
			break;
			}
		}
		else
			$tablaespejo=$tabDestino;
		return $tablaespejo;
		*/
	}//getablasepejo
	
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
//Desc: retorna el campo id de la tabla que e pasa como parametro  ejemplo si la tabla es vtiger_account  devolvera accountid
function getCampoIdKeyCrm($tabDestino){
	switch(trim($tabDestino)){
		case'vtiger_accountscf':
		case'vtiger_account':
		$campoidkey='accountid';
		break;
		
		case 'vtiger_servicecf':
		$campoidkey='serviceid';
		break;
		
		case'vtiger_products':
		case'vtiger_productcf':
		case'vtiger_productcurrencyrel':
			$campoidkey='productid';
		break;
		
		case'vtiger_accountbillads':
		case'vtiger_accountbillads':
		case'vtiger_accountshipads':
			$campoidkey='accountaddressid';
		break;
		
		case'vtiger_crmentity':
		$campoidkey='crmid';
		break;
		
		default:
			$campoidkey= substr($tabDestino,strpos($tabDestino,"_")+1); //campo que me da el nombre limpio de la tabla para luego concatenarlo con un id: vtiger_account   == account+id:: accountid
			$campoidkey=$campoidkey."id";
		break;
		}
		return $campoidkey;
	}
//////////////////////////////////////////////////////////////////////////////////
	
//////////////////////////////////////////////////////////////////////////////////
//Desc: retorna el id  primario de un registro segun un valor de referecia cedula 1130594199 gardado en accounts_cf  campo cf_598   lee el id
function getPrimaryKeyCrm($crmKey,$tabcrmkey,$tabDestino,$pointer){
	global $current_user, $adb;
	global $tablasPrinCRM;
	
	
	//arma el campo id que lleva la primary key del registro
	$campoidkey=getCampoIdKeyCrm($tabcrmkey);
	//echo "<br/>ENVIA TABLA DESTINO:".$tabDestino." CAMPOID RETORNO".$campoidkey."<br/>";
	
	//armar el puntero, ejemplo cedula, llave que identifica el regisro en crm y que viene de sai
	$pointer= trim(substr($pointer,strpos($pointer,"=")+1));  
	$pointer=str_replace("'","",$pointer);
	
	//echo "<br/>POINTER DEL REGISTRO:".$pointer."<br/>";
	echo " Funcion getPrimarykey val entrada: CRMKEY:".$crmKey." TABCRMKEY:".$tabcrmkey." TABDESTINO:".$tabDestino." POINTER:".$pointer;
	
	$sql="SELECT ".$campoidkey." FROM ".$tabcrmkey." WHERE ".$crmKey." =?";  //'".$pointer."'
	
	//echo "<br/>SQL:".$sql."<br/>";
	
	$res=$adb->pquery($sql, array($pointer));
	
	if($adb->num_rows($res)>0){
		//
		//echo 'CAMPOIDKEY CRM A RETORNAR:'.$adb->query_result($res, 0, trim($campoidkey))."</br>";
	$valRetorno	=$adb->query_result($res, 0, trim($campoidkey));
	$valRetorno=intval($valRetorno);
	return $valRetorno;
		}
		else
		{//LOG ERROR AL RECUPARAR PRIMARYKEY DEL REGISTRO
		//echo 'CAMPOIDKEY  CRM VALOR NO SE PUDO RETORNAR</br>';
			logCrm('getPrimaryKeyCrm(). Error al recuperar PRIMARYKEY del registro..   '.$sql.' pointer igual:'.$pointer);

		return false;
		}
			
	
	}//close getprimarykey
	
//////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////
//Desc: retorna el nombre de la entidad segun su id
function getBasetabla($tabla){
	$tablatmp=explode("_",$tabla);
	return $tablatmp[0];
	}
//////////////////////////////////////////////////////////////////////////////////
function especulaModulo($tabDestino){
	if(strstr($tabDestino,"account")) 
		return 'Accounts';

	elseif(strstr($tabDestino,"contact"))  
		return 'Contacts';
	
	elseif(strstr($tabDestino,"product"))  
		return 'Products';

	elseif(strstr($tabDestino,"service"))  
		return 'Services';
		
	elseif(strstr($tabDestino,"pricebook"))  
		return 'PriceBooks';
	
	else return false;
		
		
	
	}//end especulaModulo

/////////////////////////////////////////////////////////////////////////////////////
///////////  crea un nuevo registro para Accounts, Contacts, 

function crearNuevoRegistro($data,$tabDestino, $nameCampoDestino,$tipCampo,$data,$crmKeyId=0,$pointer,$pointerID,$condicion){
		global $current_user, $adb;
		global $dbFirebird; 
		
		/*echo 'dentro de la FUNCION CREAR NUEVO REGISTRO';
		exit();
		
		*/
		
		//Recupera el nombre del modulo al cual se hace referecia.
		$moduloNombre= especulaModulo($tabDestino); //Accounts 'Services';


		echo "-------------- Crearnuevoregistro; <br/>".$tipCampo;
	
	//Comprobacion si existe el registro para no repetirlo
	$sql="select ".$nameCampoDestino." from ".$tabDestino." where ".$nameCampoDestino."=?";
	$res=$adb->pquery($sql, array($data));
	if($adb->num_rows($res)<1){
	// Si no existe procede ha hacer toda la rutina, nueva creacion de registro en crm.	
	$sql="update vtiger_crmentity_seq set id=LAST_INSERT_ID(id+1)";
	
	$res=$adb->pquery($sql, array());
		if($adb->getAffectedRowCount($res)>0){
							
			
			$sql="select id from vtiger_crmentity_seq";
			$res1=$adb->pquery($sql, array());
//REs			
			$idcrmentity=$adb->query_result($res1, 0, 'id');
			
//			echo "ID CRM ENTITY:: ".$idcrmentity;
			
			$sql="insert into vtiger_crmentity (crmid,smcreatorid,smownerid,setype,description,createdtime,modifiedtime) values(?,?,?,?,?,?,?)";
			$res2=$adb->pquery($sql, array($idcrmentity,'1','1',$moduloNombre,'',getFullTimeAct(),getFullTimeAct()));
			if($adb->getAffectedRowCount($res2)>0){
				

				$sql="select cur_id,prefix from vtiger_modentity_num where active=? AND semodule=?";
				$res3=$adb->pquery($sql, array(1,$moduloNombre));
				if($adb->num_rows($res3)>0){
					
				$modPrefijo=$adb->query_result($res3, 0, 'prefix');	
				$cur_id=$adb->query_result($res3, 0, 'cur_id');	
				$cur_id_Sig=0;
				$cur_id_Sig= $cur_id+1;
						
						//Acontinuacion guarda en las tablas relativas a cada modulo
						switch($moduloNombre){
							
		case 'Accounts':
													
						$sql="insert into vtiger_account(accountid,account_no) values(?,?)";
						$res6=$adb->pquery($sql, array($idcrmentity,$modPrefijo.$cur_id)); //ej. 30,ACC2    $modPrefijoCur_id  $cur_id_Sig  $cur_id
						
						if($adb->getAffectedRowCount($res6)>0){
							$sql="insert into vtiger_accountbillads(accountaddressid) values(?)";
							$res7=$adb->pquery($sql, array($idcrmentity));
							if($adb->getAffectedRowCount($res7)>0){
								
								$sql="insert into vtiger_accountshipads(accountaddressid) values(?)";
								$res8=$adb->pquery($sql, array($idcrmentity));
								
								if($adb->getAffectedRowCount($res8)>0){
										$sql="insert into vtiger_accountscf(accountid) values(?)";
										$res9=$adb->pquery($sql, array($idcrmentity));
										
										if($adb->getAffectedRowCount($res9)>0){
										$sql="UPDATE vtiger_modentity_num SET cur_id = ? WHERE semodule LIKE ? AND active =?";
										$cur_id =$cur_id+1;
										$res10=$adb->pquery($sql, array($cur_id_Sig,$moduloNombre,1)); //$cur_id_Sig= $cur_id
											if($adb->getAffectedRowCount($res10)>0){
												return $idcrmentity;
											}
											else{
											logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
											return false;
												}
										}
										else{
											logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
											return false;
												}
									}
									
								else{
									logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
									return false;
												}
								}
								else{
									logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
									return false;
												}
							}
						else{
							logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
							return false;
												}
						 
		break; // $moduloNombre - Accounts
							
		case'Contacts':
							
		break;// $moduloNombre - Contacts
		
		case'Products':
		echo '<br/> MODULO:'.$modPrefijo.' CONSECUTIVO PREFIJO:'.$cur_id."<br/>";
		$sql="insert into vtiger_products(productid,product_no)values(?,?)";
		$res6=$adb->pquery($sql, array($idcrmentity,$modPrefijo.$cur_id)); //ej. 30,ACC2    $modPrefijoCur_id
		if($adb->getAffectedRowCount($res6)>0){
			$sql="insert into vtiger_productcf(productid) values(?)";
			$res7=$adb->pquery($sql, array($idcrmentity));
				if($adb->getAffectedRowCount($res7)>0){
//Modificar para RATE
				$sql="select conversion_rate from vtiger_currency_info where id=?";
				$res8=$adb->pquery($sql, array(1));
				if($adb->num_rows($res8)>0){
				$conversionRate=$adb->query_result($res8, 0, 'conversion_rate');
						$sql="insert into vtiger_productcurrencyrel values(?,?,?,?)";
							$res9=$adb->pquery($sql, array($idcrmentity,1,0,0));
							if($adb->getAffectedRowCount($res9)>0){
								$sql="UPDATE vtiger_modentity_num SET cur_id = ? WHERE semodule LIKE ? AND active =?";
										$cur_id =$cur_id+1;
										$res10=$adb->pquery($sql, array($cur_id_Sig,$moduloNombre,1)); //$cur_id_Sig= $cur_id
											if($adb->getAffectedRowCount($res10)>0){
												return $idcrmentity;
											}
											else{
											logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
											return false;
												}
							
							}
							else{
							logCrm('crearNuevoRegistro() -  Productos. Error al ejecutar la consulta: '.$sql);
							return false;
						     	}
					
					}
					else{
							logCrm('crearNuevoRegistro() -  Productos. Error no hay resultados en la consulta: '.$sql);
							return false;
						     	}				
				}
				else{
				logCrm('crearNuevoRegistro() - Productos. Error al ejecutar la consulta: '.$sql);
				return false;
				}
			
			}
			else{
				logCrm('crearNuevoRegistro() - Productos. Error al ejecutar la consulta: '.$sql);
				return false;
				}
		break;// $moduloNombre - Productos	
		
		case'Services':
		$sql="insert into vtiger_service(serviceid,service_no)values(?,?)";
		$res6=$adb->pquery($sql, array($idcrmentity,$modPrefijo.$cur_id)); //ej. 30,ACC2    $modPrefijoCur_id
						
						if($adb->getAffectedRowCount($res6)>0){
							$sql="insert into vtiger_servicecf(serviceid) values(?)";
							$res7=$adb->pquery($sql, array($idcrmentity));
							if($adb->getAffectedRowCount($res7)>0){
							$sql="select conversion_rate from vtiger_currency_info where id=?";
							$res8=$adb->pquery($sql, array(1));
							if($adb->num_rows($res8)>0){
							$conversionRate=$adb->query_result($res8, 0, 'conversion_rate');	
//Modificar para RATE		
							$sql="insert into vtiger_productcurrencyrel values(?,?,?,?)";
							$res9=$adb->pquery($sql, array($idcrmentity,1,0,0));
							if($adb->getAffectedRowCount($res9)>0){
								$sql="UPDATE vtiger_modentity_num SET cur_id = ? WHERE semodule LIKE ? AND active =?";
										$cur_id =$cur_id+1;
										$res10=$adb->pquery($sql, array($cur_id_Sig,$moduloNombre,1)); //$cur_id_Sig= $cur_id
											if($adb->getAffectedRowCount($res10)>0){
												return $idcrmentity;
											}
											else{
											logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
											return false;
												}
							
							}
							else{
							logCrm('crearNuevoRegistro() - Servicios. Error no hay resultados en la consulta: '.$sql);
							return false;
						     	}
							
							}
							else{
							logCrm('crearNuevoRegistro() - Servicios. Error no hay resultados en la consulta: '.$sql);
							return false;
						     	}

							}
							else{
							logCrm('crearNuevoRegistro() - Servicios. Error al ejecutar la consulta: '.$sql);
							return false;
						     	}
						}
						else{
							logCrm('crearNuevoRegistro() - Servicios. Error al ejecutar la consulta: '.$sql);
							return false;
							}
		
		
		break;// $moduloNombre - Products					
							
							}// switch moduloNombre
							
					}
					else{
						logCrm('crearNuevoRegistro(). Errror, no se pudo rescatar el valor de cur_id de la tabla, vtiger_modentity_num,  no se encontraron resultados, posiblemente este modulo este inactivo. : '.$sql);
						return false;
												}
				
			}else{
				logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
				return false;
												}
						
		
		}//updatecrmentity
		else{
			logCrm('crearNuevoRegistro(). Error al ejecutar la consulta: '.$sql);
			return false;
												}
	
	}//if comprobacion si existe el registro
	else
	{
		//campo ayuda cuando se crea desde crm a sai setea las banderas  para esto se setea la  la bandera
		setDefaultSai($pointer,$pointerID,'CREATED');
	echo ' Si hay Registro Procede a omitir.  ';
	}
												
	}//close crearnuevoRegistro

//////////////////////////////////////////////////////////////////////////////////
//Descrip: Registra campos de SAI A CRM segun parametros  com la siguiente informacion
//val In: tabla destino, nombre campo destino, tipo campo lista_:list :: texto_:text. :: compuesto_comp, data :valor a insertar, crmkey:id del registro en crm
//Val Out: True ó False 
function regiterDatos($tipoEntidad='',$tabDestino, $nameCampoDestino,$tipCampo,$data,$crmKeyId,$pointer,$pointerID,$accion,$condicion){
	global $current_user, $adb;
	global $dbFirebird;
									
	//echo "Data sin tratar: -".$data."- Cantidad:".strlen($data);
		//Se comprueba si el campo data tiene o no parametros tipo boleano si es asi setea a valores  por defect	
	/*	if(strstr($data,"True"))  {
			$data="1";
			 }
		elseif(strstr($data,"False")){
			$data="0";
			}
		else{*/
		
		
	    //////////////////////////////////////
		//	echo 'DATA INICIAL:'.$data."</br>";
		$data=utf8_encode($data); 
		$data=utf8_decode($data);
		$data=utf8_encode($data);
			
				//quitar el resto de espacios cuando se recupera desde sai la data si es necesario
				if(strstr($data,"   "))  
				$data=substr($data,0,strpos($data,"   "));
				
				echo "</br>Esta es la data para guardar despues:".$data."</br></br>";
				
				//comprobacion de campos tipo checkbox sai to crm
			//}
		
		//return false;
			
	//echo "COUNT DATA: ".strlen($data);

//ejemplo sql insert
//  INSERT INTO vtiger_cf_640_seq (cf_640id,cf_640,presence,picklist_valueid) VALUES (NULL,'MEDELLIN -5001','1','298')
	/*	$sql = "insert into vtiger_pbxmanager (pbxmanagerid,callfrom,callto,timeofcall,status)values (?,?,?,?,?)";
	$params = array($crmID, $callerName, $receiver, $timeOfCall, $status);
	$adb->pquery($sql, $params);*/
	//echo "SELECT ".$nameCampoDestino." FROM ".$tabDestino." WHERE ".$nameCampoDestino."='".$data."'";


	$campoidkey=getCampoIdKeyCrm($tabDestino);
	
echo "<br>getCampoIdKeyCrm:".$campoidkey."</br>";
	//Switch para la accion a ejecutar
	switch($accion){
		case 'created':   //	$crmKeyId
		
		if(strtolower($tipoEntidad)=='pk'){
			$crmKeyId=crearNuevoRegistro($data,$tabDestino, $nameCampoDestino,$tipCampo,$data,$crmKeyId,$pointer,$pointerID,$condicion);
			if($crmKeyId=='' && $crmKeyId==false)
			$crmKeyId=0;
			}
//exit();
		// switch para el tipo de campo
		switch($tipCampo){
				
							
				case 'list':
					$sqlpickid="select picklistid from vtiger_picklist where name='".$tabDestino."' limit 1";			//1. getpiclistid de vtiger_piclist
					$respickid=$adb->pquery($sqlpickid, array());
			
			if($adb->num_rows($respickid)>0){
				$pickListid=$adb->query_result($respickid, 0, 'picklistid');
				
					$sqlrole="select roleid from vtiger_role";													//2. recuperar todos los roles
					$resrole=$adb->pquery($sqlrole, array());
								

					$sqlpicklistvalseq="SELECT id+1 id FROM vtiger_picklistvalues_seq limit 1";						//3. get el picklistvaluesid
						$picklistvalseqres=$adb->pquery($sqlpicklistvalseq, array());
						$picklistvalseq=$adb->query_result($picklistvalseqres, 0, 'id');
					
					
					$sqltabladestinoseq="SELECT id+1 id FROM "."vtiger_".$tabDestino."_seq"." limit 1";				//4.  get el vtiger_tabladestino_seq 
						$tabladestinoseqRes=$adb->pquery($sqltabladestinoseq, array());
						$tabladestinoseq=$adb->query_result($tabladestinoseqRes, 0, 'id');
						
			
						
					//$sqltabladestino="INSERT INTO vtiger_".$tabDestino."  ('".$nameCampoDestino."','presence','picklist_valueid') VALUES (?,?,?)";   //4.1 Insert valor data
//					$sqltabladestinoRes=$adb->pquery($sqltabladestino, array($data,1,$picklistvalseq));
					
					//4.1 Insert valor data
					
					$sqlInser="INSERT INTO vtiger_".$tabDestino."  (".$tabDestino."id , ".$nameCampoDestino." , presence , picklist_valueid) VALUES (NULL,'".$data."','1','".$picklistvalseq."')";	  
					  echo "".$sqlInser."<br/><br/>";	
						$resultInsert = mysql_query($sqlInser); 
					if ($resultInsert) {
//echo "Insert Exitoso!";
							//SELECT roleid,picklistvalueid, picklistid,sortid 
							//FROM vtiger_role2picklist where picklistid=56 order by sortid asc
							$sqlrolepick="SELECT max(sortid)+1 sortid FROM vtiger_role2picklist where picklistid=?";				//5. busca el consecutivo de sortid
							$resrolepick=$adb->pquery($sqlrolepick, array($pickListid));
								if($adb->num_rows($resrolepick)>0){
									$sortid=$adb->query_result($resrolepick, 0, 'sortid');
								}
							if($picklistvalseq!='' and $pickListid!='' and $sortid!=''){
												//comprueba si  los campos son difientees de vacio por seguridad	
								
									//for para asignar a todos los roles el campo
									for($i=0;$i<$adb->num_rows($resrole);$i++){
									
										$sqlInserpick="INSERT INTO vtiger_role2picklist  (roleid,picklistvalueid,picklistid,sortid) VALUES ('".$adb->query_result($resrole, $i, 'roleid')."','".$picklistvalseq."','".$pickListid."','".$sortid."')";  
//echo $sqlInserpick;	
										$resultInsertPick = mysql_query($sqlInserpick); 
										
								/*	$sqlrole2pick="INSERT INTO vtiger_role2picklist ('roleid','picklistvalueid','picklistid','sortid') VALUES(?,?,?,?)";																										//5. escribe para habilitar roles para ese campo
									$adb->pquery($sqlrole2pick, array($adb->query_result($resrole, $i, 'roleid'),$picklistvalseq,$pickListid,$sortid));*/
														
									}
									//Actualiza los  campos autoincremento de las tablas correspondientes
									$sqlpicklistvalseq="UPDATE vtiger_picklistvalues_seq SET id=id+1";							//3_part. Incrementar get el picklistvaluesid
									$adb->pquery($sqlpicklistvalseq, array());
									
									$sqltabladestinoSeq="UPDATE "."vtiger_".$tabDestino."_seq"." SET id=id+1";					//4_part. Incrementar el vtiger_tabladestino_seq 
									$adb->pquery($sqltabladestinoSeq, array());
								}//close if $picklistvalseq!='' and $pickListid!='' and $sortid!=''
						}//close if insert exitoso
					
					else{
								logCrm('Registerdatos(). Case Created- list No se pudo insertar en la consulta: '.$sqlInser);
						//die('Invalido Query: ' . mysql_error());
						return false;
					}
									
				}//if resultados de picklist por id
					else
						return false;
				
			
			
			
				break; //termina list -created
				case 'comp':
				break; //termina comp -created
				case 'text':
				
					/*$sqlInser="INSERT INTO ".$tabDestino."  (".$tabDestino."id , ".$nameCampoDestino." , presence , picklist_valueid) VALUES (NULL,'".$data."','1','".$picklistvalseq."')";	  
						echo "".$sqlInser."<br/><br/>";	
						$resultInsert = mysql_query($sqlInser); 
					if (mysql_affected_rows()>0){
						
					}*/
					$crmKeyId=intval($crmKeyId);
					$sql="UPDATE ".$tabDestino." SET ".$nameCampoDestino." =? where ".$campoidkey."=?";  //  '".$data."' where accountid=?"
					echo "SQL DE ACTUALIZACION: ".$sql." - ".$data." - ".$crmKeyId."<br/>";
					//echo "</br>Data antes de acentuar..".$data."</br>";
					//$data=acentuar($data);
					//echo "</br>Data despues de acentuar..".$data."</br>";
					$res=$adb->pquery($sql, array($data,$crmKeyId));
					return true;
	
				break; //termina text -created
				
				case'qty':
				
				
				break;
				
				case 'tax':
				//	llama a rutina para Impuesto 
				taxSet($data,$crmKeyId);
				break;
				
				case 'boolean':
				
					if($condicion=='True:0'){
						if(strstr($data,"True"))
						   $data=0;
					   if(strstr($data,"False"))
						   $data=1;
					}
					else{
						if(strstr($data,"True"))
						   $data=1;
						if(strstr($data,"False"))
						   $data=0;
					}
							
					$sql="UPDATE ".$tabDestino." SET ".$nameCampoDestino." =? where ".$campoidkey."=?";    //  echo $sql." - ".$data." - ".$crmKe
					$res=$adb->pquery($sql, array($data,$crmKeyId));
					return true;
				    
				break; // Boolean
	
				}//termina tipocampo -created
		break; //ternima created
		
		case 'modified':
		//:::::::::::::::::::.......  Comprobacion para saber si el registro que se quiere acceder existe 
		if(strtolower($tipoEntidad)=='pk'){
			$pointerTemp=explode("=",$pointer);
			$pointerNew=trim(str_replace("'","",$pointerTemp[1]));
			//echo "MODIFICADO POINTERNEW:".$pointerNew."--";  //hacer prueba para ver si saca bien el puntero
			//exit();
			$sql="SELECT ".$nameCampoDestino." FROM ".$tabDestino." WHERE ".$nameCampoDestino." =?";    //  echo $sql." - ".$data." - ".$crmKe
			$res=$adb->pquery($sql, array($pointerNew));
			if($adb->num_rows($res)<1){
//echo " <br/>PASA A INSERTAR  data:".$data." tabladestino:".$tabDestino." namcampodestino:".$nameCampoDestino." tipocampo: ".$tipCampo." data:".$data." crmKeyId:".$crmKeyId." pointer:".$pointer." pointerID:".$pointerID." condicion:".$condicion."<br/>";
$crmKeyId=crearNuevoRegistro($data,$tabDestino, $nameCampoDestino,$tipCampo,$data,$crmKeyId,$pointer,$pointerID,$condicion);
//echo " RESULTADO DE CRMKEYID CUANDO INSERTA:".$crmKeyId;
				if($crmKeyId=='' && $crmKeyId==false)
					{
						logCrm('registerDatos() - Modified - Creando un nuevo registro por que no existe en crm para modificar. Puntero: '.$pointer);
						return false;
					}
					
				}// numrows 
				
			}//tipo entidad = pk
			//:::::::::::::::::........ Termina comprobacion del registro
			//exit();
		
			switch($tipCampo){
				
				case'qty':
			$sqlQty=	"SELECT (ONHAND - RESERVA) AS ONHAND from ITEMDET where ".$pointer;
			
			echo "Sql:: ".$sqlQty." <br/>";
			
			 $resQty= $dbFirebird->setQuery($sqlQty);
					 while($rowQty=ibase_fetch_object($resQty)){ //Extraer valor de la consulta
						$onhand=utf8_encode($rowQty->ONHAND);
						 }
						 echo "Onhand:: ".$onhand.":: <br/>";
						 
						 $sql="UPDATE ".$tabDestino." SET ".$nameCampoDestino." =? where ".$campoidkey."=?";    //  echo $sql." - ".$data." - ".$crmKe
						$resonhand=$adb->pquery($sql, array($data,$crmKeyId));
						if($adb->getAffectedRowCount($resonhand)>0){
							return true;
						}
						else{
							return false;
						}
						
						 
					 ///Recuperar ID de tabla inventoryTaxInfo
					
					
				
				break;
				
				case 'tax'://	llama a rutina para tax,insert y update auto
					$res=taxSet($data,$crmKeyId);
					return $res;
				break;
			
				case 'boolean':
				
					if($condicion=='True:0'){
						if(strstr($data,"True"))
						   $data=0;
					  if(strstr($data,"False"))
						   $data=1;
					}
					else{
						if(strstr($data,"True"))
						   $data=1;
						if(strstr($data,"False"))
						   $data=0;
					}
					
					echo 'Data para guardar en MODIFIED BOOLEAN -'. $data.'-';
							
					$sql="UPDATE ".$tabDestino." SET ".$nameCampoDestino." =? where ".$campoidkey."=?";    //  echo $sql." - ".$data." - ".$crmKe
					$res=$adb->pquery($sql, array($data,$crmKeyId));
					return true;
				    
				break;
				
				case 'list':
						$sql="UPDATE ".$tabDestino." SET ".$nameCampoDestino." =? where ".$campoidkey."=?";  //  '".$data."' where accountid=?"
												
						echo $sql." - data sin utf:/".$data."-  data con utf:'".utf8_decode($data)."/ - ".$crmKeyId;
												
						$res=$adb->pquery($sql, array($data,$crmKeyId));
						
						return true;
				break;//termina list -modified
				case 'comp':
				break;//termina comp -modified
			
				case 'text': //echo "modified tipo text";
					
					//$crmKeyId=intval($crmKeyId);
					
					$sql="UPDATE ".$tabDestino." SET ".$nameCampoDestino." =? where ".$campoidkey."=?";  //  '".$data."' where accountid=?"
					echo $sql." - ".$data." - ".$crmKeyId;
					//echo "</br>Data antes de acentuar..".$data."</br>";
					//$data=acentuar($data);
					//echo "</br>Data despues de acentuar..".$data."</br>";
					$res=$adb->pquery($sql, array($data,$crmKeyId));
					//vefificacion si guardo o no
					// $adb->num_rows($perm_result);
				/*	if($adb->getAffectedRowCount($res)>0)
					return true;
					else
					return false;*/
					return true;
					//echo  'RESPUESTA DE RES:'.$adb->getAffectedRowCount($res);
					
					
	
					/*
Nota: se necesita conocer cual es el id del registro a actualizar para eso se hara una consulta al inicio que me identifique 
					dependiendo de lo que selee en por ejemplo id_N=1130594199  para el sistemema crm seria acounts_Cf el campo serai cf_645 por 
					ejempplo entonces dependiendo dela variable fieldCrmKey del xml se buscara el id del registro si contiene  CF se buscara 
					en accounts_Cf predeterminadamente es decir desde donde provenga el campo del xml asi se conocera el id
					*/
					
				break;//termina text -modified
				}//termina tipocampo - modified
		break; //termina modified
		
		case 'deleted':
		
				$sqldeleted="UPDATE vtiger_crmentity SET deleted=? where crmid 	=?";							
						$resSql=$adb->pquery($sqldeleted, array(1,$crmKeyId));
						
						if($adb->getAffectedRowCount($resSql)>0){
							return true;
						}
						else{
							return false;
						}
						
			/*switch($tipCampo){
				case 'list':
				break;//termina list -deleted
				case 'comp':
				break;//termina comp -deleted
				case 'text':
				break;//termina text -deleted
				case 'boolean':
				break;//termina boolean -deleted
				case 'tax':
				break;//termina text -deleted
				}//termina tipocampo -deleted*/
		break; //termina deleted
		
		}//termina switch comprueba accion

	}//close function registerList


//////////////////////////////////////////////////////////////////////////////////
//Desc: Rutina para alimentar desde sai a crm el tax o impuestos. Nota: se debe tener en cuenta que los impuestos deben de estar
//		creados en ambos lados.
function taxSet($data,$crmKeyId){//OK

	global $current_user, $adb;
	global $dbFirebird;
	
	$data=	trim($data);
					$sqlTAX="SELECT FIRST 1 RATE FROM TAXAUTH WHERE AUTHORITY = '".$data."'";
					
					//echo "$sqlTAX :  ".$sqlTAX."<br/>";
					
					 $restax= $dbFirebird->setQuery($sqlTAX);
					 while($rowTax=ibase_fetch_object($restax)){ //Extraer valor de la consulta
						$rate=utf8_encode($rowTax->RATE);
						 }
						 
					 ///Recuperar ID de tabla inventoryTaxInfo
						 $sqlInventoryTax="select taxid from vtiger_inventorytaxinfo where taxlabel= ?";
						 $resInventoryTax=$adb->pquery($sqlInventoryTax, array($data));
						
						if($adb->num_rows($resInventoryTax)>0){
							$dataTax=	 $adb->query_result($resInventoryTax, 0,'taxid');
							
						  if($rate!=''){
								$sqltaxrel='select productid from vtiger_producttaxrel where  productid=?';		
								$restaxrel=$adb->pquery($sqltaxrel, array($crmKeyId));
								if($adb->num_rows($restaxrel)>0){
								//update
								//echo '<br/> Procede a ACTUALIZAR TAX - ';
									$sqlUpdate="UPDATE vtiger_producttaxrel SET taxid = ? , taxpercentage = ? WHERE productid=?";
									$resupdateTax=$adb->pquery($sqlUpdate, array($dataTax,$rate,$crmKeyId));
											if($adb->getAffectedRowCount($resupdateTax)>0)
											return true;
											else
											logCrm('- MODIFIED:TAX. UPDATE:. No se pudo actualizar SQL: '.$sqlUpdate);
									}
									else
									{//insert
								//	echo '<br/> Procede a INSERTAR TAX - ';
									$sqlInsert="INSERT INTO vtiger_producttaxrel (productid,taxid, taxpercentage) VALUES (?,?,?)";
									$resupdateTax=$adb->pquery($sqlInsert, array($crmKeyId,$dataTax,$rate));
											if($adb->getAffectedRowCount($resupdateTax)>0)
											return true;
											else{
											logCrm('- MODIFIED:TAX. INSERT:. No se pudo INSERTAR SQL: '.$ssqlInsert);	
											return false;
											}
									}
							}
							else{
								logCrm('- MODIFIED:TAX. No existe resultado de "RATE"  tratando de recuperarlo con la consulta: '.$sqlTAX.'  Recomendacion Tratar de verificar la tabla TAXAUTH en SAI.');
								return false;
											}	 
							}
						else{
							logCrm('- MODIFIED:TAX. No existe resultado de Tax relacionado en CRM para "'.$data.'"  leido desde SAI..  ');
							return false;
											}
					//echo "RATE:".$rate."<br/>";
	}//close TAXSET
	
	

//////////////////////////////////////////////////////////////////////////////////
//Desc: una vez modificado el registro se llama a esta funcion para que setee a 0 le registro que se actualizo
function setDefaultSai($pointer,$pointerID,$accion){//  OK

	global $dbFirebird;
		 $sql="UPDATE FLAGS SET ".strtoupper($accion).'=0 WHERE ID = '.$pointerID;// .'"'  

		$res= $dbFirebird->setQuery($sql);
		$affect=$dbFirebird->affectedRows($res);
		 if($affect){
		 return true;
			 }else{
				logCRM("setDefaultSai().  No se pudo setear a 0 (cero) el registro en flags...    Puntero ID:".$pointerID."| Pointero:".$pointer." | Accion:".$accion);
			 }
	}// termina setDefaultSai()
//////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////    FUNCIONES COMUNES  ///////////////////////////////////////////////////////////////

//funcion de comprobacion para chequear un campo  PREPARA PARA GUARDAR DE SAI A CRM
/*
Descripcion de los parametros de la funcion:
tipCampo: si el campo a actualizar el list_> lista, comp_> compuesto, text_> texto
tabOrigen: tabla procenente de sai
nameCampoOrigen: Campo de la tabla procendente de sai
tabDestino: tabla del crm
nameCampoDestino: campo traido de la tabla crm
condicion:  alguna condicion para tener en cuenta en la consulta sql que se hace a sai
accion:  que tipo de accion voy a hacer si editar borrar o crear un campo  
pointer: puntero leido desde los triggers de sai en la tabla flags.
$crmKey: fieldcrmKey  . me dice cual es el campo que se va a leer para relacionar en este caso el numero de cedula es una buena llave
fullTabla: me dice que debo de actualizar toda la tabla.
*/
function checkCampo($tipoEntidad='',$tipCampo,$tabOrigen,$nameCampoOrigen,$tabDestino,$nameCampoDestino,$condicion,$accion,$pointer,$pointerID,$crmKey,$tabcrmkey,$fullTabla='false'){ 
//$modo:: actualizar de sai a crm (SaitoCrm) o  actualizar de crm to sai (CrmtoSai)  
	global $current_user, $adb;
	global $dbFirebird;  //$dbFirebird = new FireBird();
	$nameCampoOrigenStatus=false; //Bandera que indica si el campo origen es compuesto ejemplo campo1,campo2
	
$nameCampoOrigenTemp='';



//Para los tipos comentarios de texto largo se etiqueta el campo de la siguiente forma para que puede ser leido por el crm el field leido de sai
	if(strstr($nameCampoOrigen,"COMMENTS")){
	$nameCampoOrigenTemp=$nameCampoOrigen;
		$nameCampoOrigen=str_replace("COMMENTS","cast(COMMENTS as VARCHAR(2000)) as COMMENTS",$nameCampoOrigen);
	}elseif(strstr($nameCampoOrigen,"MEMO"))
	{
		$nameCampoOrigenTemp=$nameCampoOrigen;
		$nameCampoOrigen=str_replace("MEMO","cast(MEMO as VARCHAR(2000)) as MEMO",$nameCampoOrigen);
	}
		
		$nameCampoOrigen=strtoupper($nameCampoOrigen);
		
		echo ' Este es el campo origen: '.$nameCampoOrigen."<br/>";		
		
		$sqlFB="SELECT  ";		
		
				if(strstr($nameCampoOrigen,","))  { //busca si tiene ',' para separar y genera un arreglo importante para listas y compuesto
				
				$nameCampoOrigen=split(',',$nameCampoOrigen);
				
				$nameCampoOrigenStatus=true; // Indica que el campo origen es de tipo compuesto
				
				  for ($i=0;$i<count($nameCampoOrigen);$i++){
					$sqlFB.=" ".$nameCampoOrigen[$i]." ";
						if($i <count($nameCampoOrigen)-1)
							$sqlFB.=" , ";					//en el arreglo se asinan los campos de esta forma campo1, campo2, campo3
						}
				}
				else //sino es tipo arreglo de campos  pone el que llego
				$sqlFB.=" ".$nameCampoOrigen." ";
					
			//sigue con la consulta		
				$sqlFB.=" FROM ".$tabOrigen;
				
				$sqlFB.=" WHERE ".$pointer;
				
				if($condicion!='')
					$sqlFB.=" AND ".$condicion;
							
echo "SQL FIREBIRD:".$sqlFB."<br />";                                                                     
				
				$res= $dbFirebird->setQuery($sqlFB);
				
	//mejora para campo Origen
	if($nameCampoOrigenTemp!='')
	$nameCampoOrigen=$nameCampoOrigenTemp;			
				
				$resultado=$dbFirebird->ibase_num_rows($res);
	
				 if($resultado>0){ 
				 //si hay resultados proceder
			
				 $res= $dbFirebird->setQuery($sqlFB);
				 while($row=ibase_fetch_object($res)){ //Extraer valor de la consulta
//TIPO LISTA:			
 			//Recupera el valor de una lista y saca su identificador
				 if($tipCampo=="list"){
				 $data='';
				 
				 
				 	if($nameCampoOrigenStatus)//si el campo origen es compuesto
					{
						
				  // El for se basa para armar segun la informacion del select un mismo valor

				 for ($i=0;$i<count($nameCampoOrigen);$i++){ 
					$dataTmp=utf8_encode($row->$nameCampoOrigen[$i]);
					if(strpos($dataTmp,"   ")>0)
					$data.=substr($dataTmp,0,strpos($dataTmp,"   "));
					else
					$data.=$dataTmp;
					
						if($i <count($nameCampoOrigen)-1)
							$data.="-";
					 				 }//close for
					
					}//end if campo origen compuesto 
					
					//SI EL CAMPO NO ES COMPUESTO
					else{
						/*BUSCA en tabla del campo la coincidenica traida por la consulta a sai en la tabla correpondiente a el tipo lista
						ej. vtiger_cf_xxx  y  finalmente es este resultado el que se guarda en crm*/							
							
							//echo " Resultados data pre:".$row->$nameCampoOrigen." - ";
							//echo  " res:".strlen($row->$nameCampoOrigen);
							//quita espacios sobrantes
							//$data =substr($row->$nameCampoOrigen,0,strpos($row->$nameCampoOrigen,"   "));
						//echo "Resultados data:".$data."    --    ";
							
							$data=$row->$nameCampoOrigen;  // DATA TRAIDA DESDE BD SAI
		//echo $data;
							//buscar coincidencia en tabla de crm
							$sql="SELECT ".$nameCampoDestino." campo FROM vtiger_".$nameCampoDestino." WHERE ".$nameCampoDestino." LIKE '%-".trim($data)."%'" ;
							
							echo "SQL PARA LISTAS: ".$sql."<BR/>";
							$resfieltemp=$adb->pquery($sql, array());
						
						if($adb->num_rows($resfieltemp)>0){
							$data=	 $adb->query_result($resfieltemp, 0,'campo');
							$data=	unhtmlentities($data);
							
							}
						else
							logCrm('checkCampo(). No existe resutado en crm para insertar en la otra db..   '.$sql.' pointer igual:'.$pointer);
						
								//echo "FINAL DE RESULTADO PARA DATA LISTA: ".$data;
							
							//exit();
						}//end ifelse campo origen compuesto 
									 
				 }//if que me dice si es tipo lista 
						 
						 /*TIPO COMPUESTO: Es cuando se quire armar con los datos que envie una consulta un nuevo valor,
						 	Ejeplo un tipo de datos compuesto en la consulta seria select CAMPO1, CAMPO2 FROM ...
							y quedaria de la siguiente forma: CAMPO1-CAMPO2 el valor a insertar en crm
						 */
						 
						 else if($tipCampo=="comp"){  //tipo de campo compuesto 
							  for ($i=0;$i<count($nameCampoOrigen);$i++){ 
								$dataTmp=utf8_encode($row->$nameCampoOrigen[$i]);
									if(strpos($dataTmp,"   ")>0)
										$data.=substr($dataTmp,0,strpos($dataTmp,"   "));
									else
										$data.=$dataTmp;
					
							if($i <count($nameCampoOrigen)-1)
									$data.="-";
									
					 				 }//close for
									 
							 }
						//Sin tipo de campo: $tipCampo  envia el campo seleccionado por defecto ejemplo select CAMPO1 FROM..
						// valor devuelto CAMPO1 : valor a insertar en  crm
						 else if($tipCampo=="text"||$tipCampo=="boolean"||$tipCampo=="tax"){  
						 $data=$row->$nameCampoOrigen;
						 }
						 else
						  $data=$row->$nameCampoOrigen;
						 

//Recupera la primary key  del registro asociado	
$crmKeyId=getPrimaryKeyCrm($crmKey,$tabcrmkey,$tabDestino,$pointer);	
					 
echo "Datos: tabladestino:".$tabDestino." nombre campo destino:".$nameCampoDestino."  tipo campo:".$tipCampo."data:".$data." condicion:".$condicion."  puntero:".$pointer." crmkey: ".$crmKey."  getprimaryKey:".$crmKeyId."<br/>";



			// 	Sincroniza 		guarda en tablas crm la info recopilada	 
			/////////////////////////////////////////////////////////////////
			//logCrm("Data antes de llamar a funcion registerDatos:".$data);
			if(isset($data)and isset($crmKeyId))
				$regdatosStat=regiterDatos($tipoEntidad,$tabDestino, $nameCampoDestino,$tipCampo,$data,$crmKeyId,$pointer,$pointerID,$accion,$condicion);
			else
				logCrm('checkCampo(). No hay data para guardar en crm.. O no hay crmKeyId de identificador.   sql:  '.$sql.' pointer:'.$pointer);
			/////////////////////////////////////////////////////////////////						  
						//registro de datos efectivo
						if($regdatosStat)
						{//setear a 0 (cero) las banderas
							setDefaultSai($pointer,$pointerID,$accion);
						}
  				   	 }//closed while
				 }
	
	}//check campo

//devuelve el tiempo en este  2011-05-16 12:52:12 formato especializado para guardar en crm
function getFullTimeAct(){
	return date('o').'-'.date('m').'-'.date('d').' '.date('H').':'.date('i').':'.date('s');
	}


//funcion getTipoempresa ;; devuelve el tipo de empresa que esta parametrizada en la configuracion global de la empresa
function getTipoempresa(){
	global $current_user, $adb;
	$sql="select tipoempresa from vtiger_organizationdetails";
$result = $adb->pquery($sql, array());

$num_rowscrm = $adb->num_rows($result);
	if($num_rowscrm>0){
		$res = $adb->query_result($result,0,'tipoempresa');
		return $res;
	}else
		return false;
	}// getTipoempresa

//funcion getMancopago ;; devuelve el tipo de empresa que esta parametrizada en la configuracion global de la empresa
function getMancopago(){
		global $current_user, $adb;
	$sql="select mancopago from vtiger_organizationdetails";
$result = $adb->pquery($sql, array());

$num_rowscrm = $adb->num_rows($result);
	if($num_rowscrm>0){
		$res =  $adb->query_result($result,0,'mancopago');
		return $res;
	}else
		return false;
	}// getMancopago
?>